# InfluencerHub AI - Prototipo Frontend

## Descripción General
InfluencerHub AI es una plataforma moderna y escalable de mercado de influencers diseñada para conectar marcas con creadores utilizando recomendaciones impulsadas por IA. Este proyecto es el **Prototipo Frontend** construido con React, Vite, TailwindCSS y Shadcn/UI.

## Características
- **Acceso Basado en Roles:** Flujos simulados para Marcas, Influencers, Administradores y Agencias.
- **Mercado:** Filtrado avanzado, búsqueda y clasificación de influencers.
- **Demo del Algoritmo de IA:** Simulador interactivo para la predicción del ROI de campañas.
- **Paneles de Control:** Vistas dedicadas para gestión de campañas, billetera/finanzas y mensajes.
- **Centro de Resolución:** Interfaz de gestión de disputas.
- **Soporte Multilingüe:** Traducciones al Español e Inglés.

## Tecnologías
- **Frontend:** React 18, TypeScript, Vite
- **Estilos:** TailwindCSS v4, Shadcn/UI
- **Enrutamiento:** Wouter
- **Estado:** React Context API (Auth, Idioma)
- **Iconos:** Lucide React

## Instalación y Despliegue

### 1. Desarrollo Local
Para ejecutar este proyecto localmente:

```bash
npm install
npm run dev
```

El servidor se iniciará en `http://localhost:5000`.

### 2. Cómo Publicar en tu Hosting (cPanel, Hostinger, GoDaddy, etc.)

Si tienes un hosting compartido (como Hostinger, Bluehost, SiteGround), sigue estos pasos para subir tu plataforma:

**Paso 1: Descargar los archivos**
1. En Replit, ve al menú del proyecto y selecciona **"Download as Zip"**.
2. Descomprime el archivo en tu computadora.
3. Busca la carpeta llamada `dist/public`. **Esta es la única carpeta que necesitas subir.**
   *(Nota: Si no ves la carpeta `dist`, ejecuta `npm run build` en la consola de Replit antes de descargar).*

**Paso 2: Subir al Hosting**
1. Entra al **Administrador de Archivos** (File Manager) de tu hosting.
2. Ve a la carpeta `public_html` (o la carpeta de tu dominio).
3. Sube todos los archivos que están DENTRO de `dist/public`.
   - Deberías ver un `index.html`, una carpeta `assets`, etc.

**Paso 3: Configurar Redirecciones (Importante)**
Como esta es una aplicación de una sola página (SPA), necesitas configurar el servidor para que todas las rutas vayan al `index.html`.

**Para servidores Apache (cPanel estándar):**
Crea un archivo llamado `.htaccess` en la misma carpeta donde subiste los archivos y pega esto:

```apache
<IfModule mod_rewrite.c>
  RewriteEngine On
  RewriteBase /
  RewriteRule ^index\.html$ - [L]
  RewriteCond %{REQUEST_FILENAME} !-f
  RewriteCond %{REQUEST_FILENAME} !-d
  RewriteRule . /index.html [L]
</IfModule>
```

**Para servidores Nginx:**
Configura tu bloque de servidor así:
```nginx
location / {
  try_files $uri $uri/ /index.html;
}
```

## Integración Backend (Siguientes Pasos)
Este es un **prototipo funcional**. Para convertirlo en el producto final descrito:
1. Implementar el backend real (Node.js/NestJS/Python).
2. Configurar la base de datos PostgreSQL.
3. Integrar autenticación real (OAuth, JWT).
4. Conectar pasarelas de pago (Stripe/PayPal/Crypto).
5. Desplegar el microservicio de IA.

## Estructura del Proyecto
- `/client/src/components`: Componentes UI (botones, tarjetas, diseño).
- `/client/src/pages`: Vistas completas (Landing, Dashboard, Mercado).
- `/client/src/context`: Estado global (Auth, Idioma).
- `/client/src/lib`: Utilidades y datos simulados.

---
Generado por Replit Agent para InfluencerHub AI.
