import { Switch, Route } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { TooltipProvider } from "@/components/ui/tooltip";
import NotFound from "@/pages/not-found";
import { AuthProvider } from "@/context/AuthContext";
import { LanguageProvider } from "@/context/LanguageContext";

// Pages
import LandingPage from "@/pages/LandingPage";
import MarketplacePage from "@/pages/MarketplacePage";
import AuthPage from "@/pages/AuthPage";
import DashboardPage from "@/pages/DashboardPage";
import InfluencerProfilePage from "@/pages/InfluencerProfilePage";
import AlgorithmPage from "@/pages/AlgorithmPage";
import CreateCampaignPage from "@/pages/CreateCampaignPage";
import WalletPage from "@/pages/WalletPage";
import AdminPage from "@/pages/AdminPage";
import MessagesPage from "@/pages/MessagesPage";
import DisputesPage from "@/pages/DisputesPage";
import HelpCenterPage from "@/pages/HelpCenterPage";
import SettingsPage from "@/pages/SettingsPage";

function Router() {
  return (
    <Switch>
      <Route path="/" component={LandingPage} />
      <Route path="/marketplace" component={MarketplacePage} />
      <Route path="/auth" component={AuthPage} />
      <Route path="/help" component={HelpCenterPage} />
      
      {/* Dashboard Routes */}
      <Route path="/dashboard" component={DashboardPage} />
      <Route path="/dashboard/wallet" component={WalletPage} />
      <Route path="/dashboard/messages" component={MessagesPage} />
      <Route path="/dashboard/disputes" component={DisputesPage} />
      <Route path="/dashboard/settings" component={SettingsPage} />
      <Route path="/dashboard/users" component={AdminPage} /> 
      <Route path="/dashboard/financials" component={AdminPage} /> 
      <Route path="/admin" component={AdminPage} />
      
      {/* Public Feature Routes */}
      <Route path="/influencer/:id" component={InfluencerProfilePage} />
      <Route path="/algorithm" component={AlgorithmPage} />
      <Route path="/create-campaign" component={CreateCampaignPage} />
      <Route path="/profile" component={() => <div className="p-20 text-center">Redirecting to dashboard...</div>} /> 
      
      {/* Fallback */}
      <Route component={NotFound} />
    </Switch>
  );
}

function App() {
  return (
    <QueryClientProvider client={queryClient}>
      <LanguageProvider>
        <AuthProvider>
          <TooltipProvider>
            <Toaster />
            <Router />
          </TooltipProvider>
        </AuthProvider>
      </LanguageProvider>
    </QueryClientProvider>
  );
}

export default App;
