import { Link } from "wouter";
import { Facebook, Instagram, Linkedin, Twitter, Youtube } from "lucide-react";

export function Footer() {
  return (
    <footer className="bg-white dark:bg-slate-950 border-t border-border pt-16 pb-8">
      <div className="container mx-auto px-4">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-12 mb-12">
          {/* Brand */}
          <div className="col-span-1 md:col-span-1">
            <div className="flex items-center gap-2 mb-4">
              <div className="size-8 rounded-lg bg-primary flex items-center justify-center text-white font-bold text-xl">
                I
              </div>
              <span className="font-display font-bold text-xl tracking-tight">
                Influencer<span className="text-primary">Hub</span> AI
              </span>
            </div>
            <p className="text-muted-foreground text-sm leading-relaxed mb-6">
              The #1 marketplace for automated influencer marketing. Connect, collaborate, and scale with AI-driven recommendations.
            </p>
            <div className="flex gap-4">
              <ButtonIcon Icon={Twitter} />
              <ButtonIcon Icon={Instagram} />
              <ButtonIcon Icon={Linkedin} />
              <ButtonIcon Icon={Youtube} />
            </div>
          </div>

          {/* Links */}
          <div>
            <h4 className="font-display font-bold text-foreground mb-6">Platform</h4>
            <ul className="space-y-3 text-sm text-muted-foreground">
              <li><Link href="/marketplace" className="hover:text-primary transition-colors">Marketplace</Link></li>
              <li><Link href="/algorithm" className="hover:text-primary transition-colors">AI Algorithm</Link></li>
              <li><Link href="/pricing" className="hover:text-primary transition-colors">Pricing</Link></li>
              <li><Link href="/success-stories" className="hover:text-primary transition-colors">Success Stories</Link></li>
            </ul>
          </div>

          <div>
            <h4 className="font-display font-bold text-foreground mb-6">Company</h4>
            <ul className="space-y-3 text-sm text-muted-foreground">
              <li><Link href="/about" className="hover:text-primary transition-colors">About Us</Link></li>
              <li><Link href="/careers" className="hover:text-primary transition-colors">Careers</Link></li>
              <li><Link href="/blog" className="hover:text-primary transition-colors">Blog</Link></li>
              <li><Link href="/contact" className="hover:text-primary transition-colors">Contact</Link></li>
            </ul>
          </div>

          <div>
            <h4 className="font-display font-bold text-foreground mb-6">Support</h4>
            <ul className="space-y-3 text-sm text-muted-foreground">
              <li><Link href="/help" className="hover:text-primary transition-colors">Help Center</Link></li>
              <li><Link href="/guidelines" className="hover:text-primary transition-colors">Community Guidelines</Link></li>
              <li><Link href="/disputes" className="hover:text-primary transition-colors">Dispute Resolution</Link></li>
              <li><Link href="/privacy" className="hover:text-primary transition-colors">Privacy Policy</Link></li>
            </ul>
          </div>
        </div>

        <div className="border-t border-border pt-8 flex flex-col md:flex-row justify-between items-center gap-4">
          <p className="text-xs text-muted-foreground">
            © 2025 InfluencerHub AI. All rights reserved.
          </p>
          <div className="flex gap-6 text-xs text-muted-foreground">
            <Link href="/terms" className="hover:text-primary">Terms of Service</Link>
            <Link href="/privacy" className="hover:text-primary">Privacy</Link>
            <Link href="/cookies" className="hover:text-primary">Cookies</Link>
          </div>
        </div>
      </div>
    </footer>
  );
}

function ButtonIcon({ Icon }: { Icon: any }) {
  return (
    <a href="#" className="size-8 flex items-center justify-center rounded-full bg-secondary text-secondary-foreground hover:bg-primary hover:text-white transition-all duration-200">
      <Icon className="size-4" />
    </a>
  );
}
