import heroBg from "@assets/generated_images/abstract_tech_waves_for_hero_background.png";
import influencer1 from "@assets/generated_images/fashion_influencer_portrait.png";
import influencer2 from "@assets/generated_images/tech_reviewer_influencer_portrait.png";
import influencer3 from "@assets/generated_images/travel_influencer_portrait.png";

export interface Influencer {
  id: string;
  name: string;
  handle: string;
  niche: string;
  followers: number;
  engagement: number; // Percentage
  price: number; // Starting price in USD
  image: string;
  verified: boolean;
  platform: "Instagram" | "TikTok" | "YouTube" | "Twitch" | "Twitter";
  rating: number;
  reviews: number;
  bio: string;
  location: string;
  language: string;
}

export const influencers: Influencer[] = [
  {
    id: "1",
    name: "Chloe Styles",
    handle: "@chloestyles",
    niche: "Fashion & Beauty",
    followers: 1250000,
    engagement: 4.8,
    price: 1500,
    image: influencer1,
    verified: true,
    platform: "Instagram",
    rating: 4.9,
    reviews: 124,
    bio: "Professional fashion model and content creator. I help brands tell their story through high-quality aesthetic content.",
    location: "United States",
    language: "English",
  },
  {
    id: "2",
    name: "Tech Guru Mike",
    handle: "@miketechreview",
    niche: "Technology",
    followers: 850000,
    engagement: 6.2,
    price: 2200,
    image: influencer2,
    verified: true,
    platform: "YouTube",
    rating: 5.0,
    reviews: 89,
    bio: "Deep dives into the latest tech. I only promote products I actually believe in. Honest reviews, engaged audience.",
    location: "Canada",
    language: "English",
  },
  {
    id: "3",
    name: "Wanderlust Jess",
    handle: "@jess_travels",
    niche: "Travel & Lifestyle",
    followers: 450000,
    engagement: 5.5,
    price: 800,
    image: influencer3,
    verified: true,
    platform: "TikTok",
    rating: 4.8,
    reviews: 56,
    bio: "Traveling the world one coffee shop at a time. Digital nomad sharing tips and hidden gems.",
    location: "Bali, Indonesia",
    language: "English",
  },
  {
    id: "4",
    name: "GamerX",
    handle: "@gamerx_live",
    niche: "Gaming",
    followers: 2100000,
    engagement: 3.2,
    price: 3500,
    image: "https://images.unsplash.com/photo-1560250097-0b93528c311a?w=400",
    verified: true,
    platform: "Twitch",
    rating: 4.7,
    reviews: 210,
    bio: "Pro gamer and streamer. High energy streams and community events.",
    location: "United Kingdom",
    language: "English",
  },
  {
    id: "5",
    name: "Fitness Pro Sarah",
    handle: "@fit_sarah",
    niche: "Health & Fitness",
    followers: 320000,
    engagement: 7.1,
    price: 600,
    image: "https://images.unsplash.com/photo-1517836357463-d25dfeac3438?w=400",
    verified: false,
    platform: "Instagram",
    rating: 4.9,
    reviews: 42,
    bio: "Certified personal trainer. Sharing daily workouts and nutrition tips.",
    location: "Australia",
    language: "English",
  },
  {
    id: "6",
    name: "Crypto King",
    handle: "@cryptoking",
    niche: "Finance & Crypto",
    followers: 150000,
    engagement: 8.5,
    price: 1200,
    image: "https://images.unsplash.com/photo-1556157382-97eda2d62296?w=400",
    verified: true,
    platform: "Twitter", 
    rating: 4.6,
    reviews: 30,
    bio: "Analyzing the market so you don't have to. NFA.",
    location: "United States",
    language: "English",
  }
] as const;

export const stats = {
  totalInfluencers: "15,000+",
  totalBrands: "5,200+",
  campaignsCompleted: "42,000+",
  payoutsProcessed: "$12M+",
};

export { heroBg };
