export type Language = "en" | "es";

export type TranslationKey = string;

export const translations = {
  en: {
    nav: {
      marketplace: "Marketplace",
      howItWorks: "How it Works",
      algorithm: "Algorithm",
      pricing: "Pricing",
      login: "Log in",
      getStarted: "Get Started",
      dashboard: "Dashboard",
      profile: "Profile",
      logout: "Log out",
    },
    hero: {
      badge: "AI-Powered Influencer Matching",
      title: "Scale Your Brand with",
      titleHighlight: "Smart Influence.",
      subtitle: "The first marketplace that uses AI to predict campaign ROI. Connect with verified influencers, automate deals, and pay securely in USD or Crypto.",
      ctaMarketplace: "Explore Marketplace",
      ctaInfluencer: "Join as Influencer",
      statsInfluencers: "Active Influencers",
      statsCampaigns: "Campaigns Run",
      statsPayouts: "Paid to Creators",
    },
    marketplace: {
      title: "Find Influencers",
      subtitle: "Discover verified creators for your next campaign.",
      filters: "Filters",
      niche: "Niche",
      platform: "Platform",
      priceRange: "Price Range",
      searchPlaceholder: "Search by name or niche...",
      sort: "Sort by",
      relevance: "Relevance",
      priceLowHigh: "Price: Low to High",
      priceHighLow: "Price: High to Low",
      followers: "Followers",
      noResults: "No influencers found matching your criteria.",
      clearFilters: "Clear Filters",
      verified: "Verified",
      engagement: "Engagement",
      viewProfile: "View Profile"
    },
    profile: {
      verified: "Verified Professional",
      startingPrice: "Starting price per collaboration",
      bookNow: "Book Now",
      contact: "Contact",
      escrowNote: "Funds held securely in escrow until work is completed.",
      verifiedAudience: "Verified Audience",
      highEngagement: "High Engagement Rate",
      fastResponse: "Fast Response Time",
      portfolio: "Portfolio",
      services: "Services & Pricing",
      reviews: "Reviews",
      followers: "Followers",
      avgViews: "Avg. Views",
      completedJobs: "Completed Jobs",
      location: "Location",
      select: "Select"
    },
    wallet: {
      title: "Wallet & Payments",
      balance: "Total Balance",
      available: "Available for withdrawal",
      pending: "Pending in Escrow",
      deposit: "Deposit Funds",
      withdraw: "Withdraw",
      history: "Transaction History",
      method: "Payment Method",
      amount: "Amount",
      status: "Status",
      date: "Date",
      methods: {
        stripe: "Credit Card (Stripe)",
        paypal: "PayPal",
        usdt: "USDT (Crypto)",
        bank: "Bank Transfer",
      },
    },
    admin: {
      title: "Admin Dashboard",
      users: "User Management",
      disputes: "Dispute Resolution",
      financials: "Financial Overview",
      pendingApprovals: "Pending Approvals",
      systemHealth: "System Health",
      revenue: "Total Revenue",
      activeDisputes: "Active Disputes",
      kycApps: "Influencer KYC Applications",
      reject: "Reject",
      approve: "Approve",
      noDisputes: "No active disputes requiring attention.",
      applied: "Applied",
      followers: "Followers"
    },
    settings: {
      title: "Settings",
      subtitle: "Manage your account preferences and security.",
      profile: "Profile",
      notifications: "Notifications",
      security: "Security & Privacy",
      verification: "Verification",
      publicProfile: "Public Profile",
      publicProfileDesc: "This information will be visible to other users.",
      displayName: "Display Name",
      email: "Email Address",
      bio: "Bio",
      save: "Save Changes",
      changeAvatar: "Change Avatar",
      emailNotif: "Email Notifications",
      emailNotifDesc: "Receive emails about new campaigns and messages.",
      marketing: "Marketing Emails",
      marketingDesc: "Receive news and special offers.",
      sms: "SMS Alerts",
      smsDesc: "Get urgent updates via text message.",
      twoFactor: "Two-Factor Authentication (2FA)",
      twoFactorDesc: "Secure your account with Google Authenticator.",
      enable: "Enable",
      kyc: "Identity Verification (KYC)",
      kycStatus: "Status",
      verifiedStatus: "Verified",
      uploadId: "Upload Government ID",
      uploadDesc: "Passport, Driver's License, or National ID.",
      submitKyc: "Submit for Verification",
      activeSessions: "Active Sessions",
      activeNow: "Active now"
    }
  },
  es: {
    nav: {
      marketplace: "Mercado",
      howItWorks: "Cómo Funciona",
      algorithm: "Algoritmo",
      pricing: "Precios",
      login: "Iniciar Sesión",
      getStarted: "Empezar",
      dashboard: "Panel",
      profile: "Perfil",
      logout: "Cerrar Sesión",
    },
    hero: {
      badge: "Emparejamiento de Influencers con IA",
      title: "Escala tu Marca con",
      titleHighlight: "Influencia Inteligente.",
      subtitle: "El primer mercado que utiliza IA para predecir el ROI de las campañas. Conecta con influencers verificados, automatiza acuerdos y paga de forma segura en USD o Cripto.",
      ctaMarketplace: "Explorar Mercado",
      ctaInfluencer: "Soy Influencer",
      statsInfluencers: "Influencers Activos",
      statsCampaigns: "Campañas Realizadas",
      statsPayouts: "Pagado a Creadores",
    },
    marketplace: {
      title: "Buscar Influencers",
      subtitle: "Descubre creadores verificados para tu próxima campaña.",
      filters: "Filtros",
      niche: "Nicho",
      platform: "Plataforma",
      priceRange: "Rango de Precio",
      searchPlaceholder: "Buscar por nombre o nicho...",
      sort: "Ordenar por",
      relevance: "Relevancia",
      priceLowHigh: "Precio: Bajo a Alto",
      priceHighLow: "Precio: Alto a Bajo",
      followers: "Seguidores",
      noResults: "No se encontraron influencers con esos criterios.",
      clearFilters: "Limpiar Filtros",
      verified: "Verificado",
      engagement: "Interacción",
      viewProfile: "Ver Perfil"
    },
    profile: {
      verified: "Profesional Verificado",
      startingPrice: "Precio inicial por colaboración",
      bookNow: "Reservar Ahora",
      contact: "Contactar",
      escrowNote: "Fondos retenidos en depósito seguro hasta completar el trabajo.",
      verifiedAudience: "Audiencia Verificada",
      highEngagement: "Alta Tasa de Interacción",
      fastResponse: "Respuesta Rápida",
      portfolio: "Portafolio",
      services: "Servicios y Precios",
      reviews: "Reseñas",
      followers: "Seguidores",
      avgViews: "Vistas Prom.",
      completedJobs: "Trabajos Completados",
      location: "Ubicación",
      select: "Seleccionar"
    },
    wallet: {
      title: "Billetera y Pagos",
      balance: "Saldo Total",
      available: "Disponible para retiro",
      pending: "Pendiente en Escrow",
      deposit: "Depositar Fondos",
      withdraw: "Retirar Fondos",
      history: "Historial de Transacciones",
      method: "Método de Pago",
      amount: "Monto",
      status: "Estado",
      date: "Fecha",
      methods: {
        stripe: "Tarjeta de Crédito (Stripe)",
        paypal: "PayPal",
        usdt: "USDT (Cripto)",
        bank: "Transferencia Bancaria",
      },
    },
    admin: {
      title: "Panel de Administración",
      users: "Gestión de Usuarios",
      disputes: "Resolución de Disputas",
      financials: "Resumen Financiero",
      pendingApprovals: "Aprobaciones Pendientes",
      systemHealth: "Salud del Sistema",
      revenue: "Ingresos Totales",
      activeDisputes: "Disputas Activas",
      kycApps: "Solicitudes KYC de Influencers",
      reject: "Rechazar",
      approve: "Aprobar",
      noDisputes: "No hay disputas activas que requieran atención.",
      applied: "Aplicó",
      followers: "Seguidores"
    },
    settings: {
      title: "Configuración",
      subtitle: "Gestiona tus preferencias y seguridad.",
      profile: "Perfil",
      notifications: "Notificaciones",
      security: "Seguridad y Privacidad",
      verification: "Verificación",
      publicProfile: "Perfil Público",
      publicProfileDesc: "Esta información será visible para otros usuarios.",
      displayName: "Nombre Visible",
      email: "Correo Electrónico",
      bio: "Biografía",
      save: "Guardar Cambios",
      changeAvatar: "Cambiar Avatar",
      emailNotif: "Notificaciones por Email",
      emailNotifDesc: "Recibe correos sobre nuevas campañas y mensajes.",
      marketing: "Correos de Marketing",
      marketingDesc: "Recibe noticias y ofertas especiales.",
      sms: "Alertas SMS",
      smsDesc: "Recibe actualizaciones urgentes por mensaje de texto.",
      twoFactor: "Autenticación de Dos Factores (2FA)",
      twoFactorDesc: "Asegura tu cuenta con Google Authenticator.",
      enable: "Habilitar",
      kyc: "Verificación de Identidad (KYC)",
      kycStatus: "Estado",
      verifiedStatus: "Verificado",
      uploadId: "Subir Documento de Identidad",
      uploadDesc: "Pasaporte, Licencia de Conducir o DNI.",
      submitKyc: "Enviar para Verificación",
      activeSessions: "Sesiones Activas",
      activeNow: "Activo ahora"
    }
  }
};
