import { DashboardLayout } from "@/components/layout/DashboardLayout";
import { useLanguage } from "@/context/LanguageContext";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { Input } from "@/components/ui/input";
import { AlertTriangle, CheckCircle, XCircle, Users, DollarSign, Activity, ShieldCheck, UserCheck, FileText } from "lucide-react";
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from "@/components/ui/table";

export default function AdminPage() {
  const { t } = useLanguage();

  const users = [
    { id: 1, name: "Chloe Styles", role: "Influencer", status: "Verified", joined: "2024-01-15" },
    { id: 2, name: "TechNova Inc.", role: "Brand", status: "Active", joined: "2024-02-20" },
    { id: 3, name: "Mark Gamer", role: "Influencer", status: "Pending", joined: "2024-05-20" },
    { id: 4, name: "Viral Agency", role: "Agency", status: "Active", joined: "2024-03-10" },
  ];

  return (
    <DashboardLayout>
      <div className="mb-8">
        <h1 className="text-3xl font-display font-bold text-red-600">{t('admin.title')}</h1>
        <p className="text-muted-foreground">SuperAdmin Control Panel</p>
      </div>

      <div className="grid md:grid-cols-4 gap-4 mb-8">
         <AdminStat title={t('admin.users')} value="12,405" icon={<Users className="size-4" />} />
         <AdminStat title={t('admin.revenue')} value="$452,000" icon={<DollarSign className="size-4" />} />
         <AdminStat title={t('admin.activeDisputes')} value="3" icon={<AlertTriangle className="size-4 text-red-500" />} />
         <AdminStat title={t('admin.systemHealth')} value="99.9%" icon={<Activity className="size-4 text-green-500" />} />
      </div>

      <Tabs defaultValue="approvals" className="space-y-6">
        <TabsList>
          <TabsTrigger value="approvals">{t('admin.pendingApprovals')}</TabsTrigger>
          <TabsTrigger value="users">{t('admin.users')}</TabsTrigger>
          <TabsTrigger value="disputes">{t('admin.disputes')}</TabsTrigger>
          <TabsTrigger value="financials">{t('admin.financials')}</TabsTrigger>
        </TabsList>

        <TabsContent value="approvals">
          <Card>
            <CardHeader>
              <CardTitle>{t('admin.kycApps')}</CardTitle>
            </CardHeader>
            <CardContent>
              <div className="space-y-4">
                {[1, 2, 3].map((i) => (
                  <div key={i} className="flex items-center justify-between p-4 border rounded-lg hover:bg-secondary/10 transition-colors">
                    <div className="flex items-center gap-4">
                      <div className="size-12 rounded-full bg-gray-200 flex items-center justify-center">
                         <UserCheck className="size-6 text-gray-500" />
                      </div>
                      <div>
                        <h4 className="font-bold">New Influencer {i}</h4>
                        <p className="text-sm text-muted-foreground">{t('admin.applied')} 2h ago • Instagram • 50k {t('admin.followers')}</p>
                        <div className="flex gap-2 mt-1">
                           <Badge variant="outline" className="text-xs">Passport Uploaded</Badge>
                           <Badge variant="outline" className="text-xs">Face Match: 98%</Badge>
                        </div>
                      </div>
                    </div>
                    <div className="flex gap-2">
                      <Button size="sm" variant="outline" className="text-red-500 hover:text-red-600 hover:bg-red-50"><XCircle className="mr-1 size-4" /> {t('admin.reject')}</Button>
                      <Button size="sm" className="bg-green-600 hover:bg-green-700"><CheckCircle className="mr-1 size-4" /> {t('admin.approve')}</Button>
                    </div>
                  </div>
                ))}
              </div>
            </CardContent>
          </Card>
        </TabsContent>

        <TabsContent value="users">
           <Card>
             <CardHeader>
               <CardTitle>All Users</CardTitle>
               <div className="flex gap-2">
                 <Input placeholder="Search users..." className="max-w-sm" />
                 <Button variant="outline">Filter</Button>
               </div>
             </CardHeader>
             <CardContent>
               <Table>
                 <TableHeader>
                   <TableRow>
                     <TableHead>ID</TableHead>
                     <TableHead>Name</TableHead>
                     <TableHead>Role</TableHead>
                     <TableHead>Status</TableHead>
                     <TableHead>Joined</TableHead>
                     <TableHead className="text-right">Actions</TableHead>
                   </TableRow>
                 </TableHeader>
                 <TableBody>
                   {users.map((u) => (
                     <TableRow key={u.id}>
                       <TableCell>{u.id}</TableCell>
                       <TableCell className="font-medium">{u.name}</TableCell>
                       <TableCell>{u.role}</TableCell>
                       <TableCell>
                         <Badge variant={u.status === 'Verified' ? 'default' : 'secondary'}>{u.status}</Badge>
                       </TableCell>
                       <TableCell>{u.joined}</TableCell>
                       <TableCell className="text-right">
                         <Button size="sm" variant="ghost">Edit</Button>
                       </TableCell>
                     </TableRow>
                   ))}
                 </TableBody>
               </Table>
             </CardContent>
           </Card>
        </TabsContent>

        <TabsContent value="disputes">
           <Card>
             <CardContent className="p-12 text-center">
               <div className="bg-green-100 size-16 rounded-full flex items-center justify-center mx-auto mb-4">
                 <ShieldCheck className="size-8 text-green-600" />
               </div>
               <h3 className="text-lg font-bold text-foreground mb-2">All Clear</h3>
               <p className="text-muted-foreground">{t('admin.noDisputes')}</p>
             </CardContent>
           </Card>
        </TabsContent>

        <TabsContent value="financials">
           <div className="grid md:grid-cols-2 gap-6">
             <Card>
               <CardHeader>
                 <CardTitle>Revenue Stream</CardTitle>
               </CardHeader>
               <CardContent className="h-[200px] flex items-center justify-center bg-secondary/10 rounded-lg border border-dashed">
                 <span className="text-muted-foreground">Chart Placeholder</span>
               </CardContent>
             </Card>
             <Card>
                <CardHeader>
                  <CardTitle>Recent Escrow Releases</CardTitle>
                </CardHeader>
                <CardContent>
                  <ul className="space-y-4">
                    <li className="flex justify-between items-center">
                      <span>Release to @chloestyles</span>
                      <span className="font-bold font-mono">$1,500.00</span>
                    </li>
                    <li className="flex justify-between items-center">
                      <span>Refund to TechNova</span>
                      <span className="font-bold font-mono text-red-500">-$500.00</span>
                    </li>
                  </ul>
                </CardContent>
             </Card>
           </div>
        </TabsContent>
      </Tabs>
    </DashboardLayout>
  );
}

function AdminStat({ title, value, icon }: any) {
  return (
    <Card>
       <CardContent className="p-6">
         <div className="flex justify-between items-start mb-2">
           <p className="text-sm font-medium text-muted-foreground">{title}</p>
           {icon}
         </div>
         <h3 className="text-2xl font-bold">{value}</h3>
       </CardContent>
    </Card>
  );
}
