import { Navbar } from "@/components/layout/Navbar";
import { Footer } from "@/components/layout/Footer";
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from "@/components/ui/card";
import { Slider } from "@/components/ui/slider";
import { useState } from "react";
import { BrainCircuit, Zap, Target, Users, TrendingUp } from "lucide-react";
import { influencers } from "@/lib/mock-data";
import { InfluencerCard } from "@/components/ui/influencer-card";

export default function AlgorithmPage() {
  const [budget, setBudget] = useState([2000]);
  const [reach, setReach] = useState(50000);

  const handleSimulate = () => {
    // Simple simulation logic
    const estimatedReach = budget[0] * 45; // Mock 45 views per dollar
    setReach(estimatedReach);
  };

  return (
    <div className="min-h-screen bg-background">
      <Navbar />

      {/* Hero */}
      <section className="py-20 bg-black text-white relative overflow-hidden">
        <div className="absolute inset-0 bg-[url('https://www.transparenttextures.com/patterns/stardust.png')] opacity-20" />
        <div className="absolute top-0 right-0 w-1/2 h-full bg-gradient-to-l from-purple-900/50 to-transparent" />
        
        <div className="container mx-auto px-4 relative z-10 text-center">
          <div className="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-purple-500/20 border border-purple-500/40 text-purple-300 text-sm font-medium mb-6">
            <BrainCircuit className="size-4" />
            <span>InfluencerHub Intelligence™</span>
          </div>
          <h1 className="text-5xl md:text-7xl font-display font-bold mb-6 tracking-tight">
            Predict the <span className="text-transparent bg-clip-text bg-gradient-to-r from-purple-400 to-pink-500">Unpredictable.</span>
          </h1>
          <p className="text-xl text-gray-400 max-w-2xl mx-auto mb-10">
            Our proprietary algorithm analyzes 50+ data points to match your brand with influencers who don't just have followers, but have <em>influence</em>.
          </p>
        </div>
      </section>

      {/* Interactive Demo */}
      <section className="py-20 -mt-10">
        <div className="container mx-auto px-4">
          <Card className="shadow-2xl border-none bg-card/80 backdrop-blur-xl">
            <CardHeader className="text-center border-b">
              <CardTitle className="text-2xl font-display">ROI Simulator</CardTitle>
              <CardDescription>See what our algorithm can do for your budget.</CardDescription>
            </CardHeader>
            <CardContent className="p-8">
              <div className="grid md:grid-cols-2 gap-12">
                <div className="space-y-8">
                   <div className="space-y-4">
                     <div className="flex justify-between">
                       <label className="font-bold">Campaign Budget</label>
                       <span className="text-primary font-bold font-mono text-xl">${budget[0].toLocaleString()}</span>
                     </div>
                     <Slider 
                       value={budget} 
                       onValueChange={(v) => { setBudget(v); handleSimulate(); }} 
                       max={50000} 
                       step={500} 
                       className="py-4"
                     />
                     <p className="text-sm text-muted-foreground">Slide to adjust your monthly spend.</p>
                   </div>

                   <div className="grid grid-cols-2 gap-4">
                     <div className="bg-secondary/30 p-4 rounded-lg border border-border/50">
                        <div className="flex items-center gap-2 text-muted-foreground mb-2">
                          <Users className="size-4" /> Est. Reach
                        </div>
                        <p className="text-2xl font-bold">{reach.toLocaleString()}+</p>
                     </div>
                     <div className="bg-secondary/30 p-4 rounded-lg border border-border/50">
                        <div className="flex items-center gap-2 text-muted-foreground mb-2">
                          <Target className="size-4" /> Est. Conversions
                        </div>
                        <p className="text-2xl font-bold">{(reach * 0.025).toFixed(0)}</p>
                     </div>
                   </div>
                   
                   <Button className="w-full h-12 text-lg bg-gradient-to-r from-primary to-purple-600 border-0">
                     Start a Campaign Now
                   </Button>
                </div>

                <div className="bg-secondary/20 rounded-xl p-6 border border-border/50">
                   <h4 className="font-bold mb-4 flex items-center gap-2">
                     <Zap className="size-4 text-yellow-500" /> Recommended Strategy
                   </h4>
                   <p className="text-sm text-muted-foreground mb-6">
                     Based on a <strong>${budget[0].toLocaleString()}</strong> budget, our AI recommends a mix of Micro-Influencers for high engagement.
                   </p>
                   
                   <div className="space-y-4">
                     <p className="text-xs font-bold uppercase text-muted-foreground">Top Matches</p>
                     {influencers.slice(0, 2).map(inf => (
                        <div key={inf.id} className="scale-90 origin-left -ml-4">
                          <InfluencerCard influencer={inf} />
                        </div>
                     ))}
                   </div>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>
      </section>
      
      <Footer />
    </div>
  );
}
