import { useState } from "react";
import { useLocation } from "wouter";
import { useAuth, UserRole } from "@/context/AuthContext";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle } from "@/components/ui/card";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Separator } from "@/components/ui/separator";
import { Navbar } from "@/components/layout/Navbar";
import { CheckCircle2, Loader2 } from "lucide-react";

export default function AuthPage() {
  const [, setLocation] = useLocation();
  const { login, isLoading } = useAuth();
  
  // Quick hack to read query params in wouter since it doesn't support it natively well
  const query = new URLSearchParams(window.location.search);
  const defaultTab = query.get("tab") || "login";

  const handleLogin = async (role: UserRole) => {
    await login(role);
    setLocation("/dashboard");
  };

  return (
    <div className="min-h-screen bg-secondary/30 flex flex-col">
      <Navbar />
      
      <div className="flex-1 flex items-center justify-center p-4">
        <Card className="w-full max-w-md shadow-2xl border-border/50">
          <CardHeader className="text-center space-y-1">
            <CardTitle className="text-2xl font-display font-bold">
              Welcome to InfluencerHub
            </CardTitle>
            <CardDescription>
              Connect, Collaborate, and Scale.
            </CardDescription>
          </CardHeader>
          <CardContent>
            <Tabs defaultValue={defaultTab} className="w-full">
              <TabsList className="grid w-full grid-cols-2 mb-4">
                <TabsTrigger value="login">Login</TabsTrigger>
                <TabsTrigger value="register">Register</TabsTrigger>
              </TabsList>
              
              <TabsContent value="login" className="space-y-4">
                <div className="space-y-2">
                  <Label htmlFor="email">Email</Label>
                  <Input id="email" placeholder="m@example.com" />
                </div>
                <div className="space-y-2">
                  <Label htmlFor="password">Password</Label>
                  <Input id="password" type="password" />
                </div>
                <Button className="w-full" disabled={isLoading}>
                  {isLoading && <Loader2 className="mr-2 h-4 w-4 animate-spin" />}
                  Sign In
                </Button>
                
                <div className="relative">
                  <div className="absolute inset-0 flex items-center">
                    <span className="w-full border-t" />
                  </div>
                  <div className="relative flex justify-center text-xs uppercase">
                    <span className="bg-background px-2 text-muted-foreground">
                      Or demo as
                    </span>
                  </div>
                </div>
                
                <div className="grid grid-cols-2 gap-2">
                  <Button variant="outline" onClick={() => handleLogin("brand")} disabled={isLoading}>
                    Brand Demo
                  </Button>
                  <Button variant="outline" onClick={() => handleLogin("influencer")} disabled={isLoading}>
                    Influencer Demo
                  </Button>
                  <Button variant="outline" onClick={() => handleLogin("agency")} disabled={isLoading}>
                    Agency Demo
                  </Button>
                  <Button variant="outline" onClick={() => handleLogin("admin")} disabled={isLoading}>
                    Admin Demo
                  </Button>
                </div>
              </TabsContent>
              
              <TabsContent value="register" className="space-y-4">
                <div className="grid grid-cols-2 gap-4 mb-4">
                   <div className="border rounded-lg p-4 cursor-pointer hover:border-primary hover:bg-primary/5 transition-all text-center space-y-2">
                      <div className="mx-auto bg-primary/10 w-10 h-10 rounded-full flex items-center justify-center text-primary font-bold">B</div>
                      <h3 className="font-bold text-sm">Brand</h3>
                      <p className="text-xs text-muted-foreground">I want to hire influencers</p>
                   </div>
                   <div className="border rounded-lg p-4 cursor-pointer hover:border-primary hover:bg-primary/5 transition-all text-center space-y-2">
                      <div className="mx-auto bg-purple-100 w-10 h-10 rounded-full flex items-center justify-center text-purple-600 font-bold">I</div>
                      <h3 className="font-bold text-sm">Influencer</h3>
                      <p className="text-xs text-muted-foreground">I want to find jobs</p>
                   </div>
                </div>
                
                <div className="space-y-2">
                  <Label htmlFor="name">Full Name</Label>
                  <Input id="name" placeholder="John Doe" />
                </div>
                <div className="space-y-2">
                  <Label htmlFor="reg-email">Email</Label>
                  <Input id="reg-email" placeholder="m@example.com" />
                </div>
                <div className="space-y-2">
                  <Label htmlFor="reg-password">Password</Label>
                  <Input id="reg-password" type="password" />
                </div>
                
                <Button className="w-full" onClick={() => handleLogin("influencer")}>
                  Create Account
                </Button>
              </TabsContent>
            </Tabs>
          </CardContent>
          <CardFooter className="justify-center text-sm text-muted-foreground">
            Protected by reCAPTCHA and subject to Privacy Policy.
          </CardFooter>
        </Card>
      </div>
    </div>
  );
}
