import { DashboardLayout } from "@/components/layout/DashboardLayout";
import { useAuth } from "@/context/AuthContext";
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Plus, TrendingUp, Users, DollarSign, Clock, CheckCircle2 } from "lucide-react";
import { influencers } from "@/lib/mock-data";
import { InfluencerCard } from "@/components/ui/influencer-card";
import { Link } from "wouter";

export default function DashboardPage() {
  const { user } = useAuth();

  if (!user) return null;

  return (
    <DashboardLayout>
      <div className="mb-8 flex flex-col md:flex-row md:items-center justify-between gap-4">
        <div>
          <h1 className="text-3xl font-display font-bold">Dashboard</h1>
          <p className="text-muted-foreground">Welcome back, {user.name}. Here's what's happening today.</p>
        </div>
        {user.role === "brand" && (
          <Link href="/create-campaign">
            <Button className="shadow-lg shadow-primary/20">
              <Plus className="mr-2 size-4" /> Create Campaign
            </Button>
          </Link>
        )}
      </div>

      {/* Stats Row */}
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-8">
        <StatsCard 
          title="Total Spend" 
          value="$12,450" 
          icon={<DollarSign className="size-4" />} 
          trend="+12% from last month" 
        />
        <StatsCard 
          title="Active Campaigns" 
          value="3" 
          icon={<MegaphoneIcon className="size-4" />} 
          trend="2 ending soon" 
        />
        <StatsCard 
          title="Total Reach" 
          value="2.4M" 
          icon={<Users className="size-4" />} 
          trend="+8% organic growth" 
        />
        <StatsCard 
          title="Avg. ROI" 
          value="3.2x" 
          icon={<TrendingUp className="size-4" />} 
          trend="Top 10% of market" 
        />
      </div>

      <div className="grid lg:grid-cols-3 gap-8">
        {/* Main Feed */}
        <div className="lg:col-span-2 space-y-8">
          {/* Active Campaigns */}
          <Card>
            <CardHeader>
              <CardTitle>Active Campaigns</CardTitle>
              <CardDescription>Monitor your ongoing collaborations</CardDescription>
            </CardHeader>
            <CardContent className="space-y-4">
              {[1, 2].map((i) => (
                <div key={i} className="flex items-center justify-between p-4 rounded-lg border bg-card/50 hover:bg-accent/50 transition-colors">
                  <div className="flex items-center gap-4">
                    <div className="size-10 rounded-full bg-primary/10 flex items-center justify-center text-primary">
                       <MegaphoneIcon className="size-5" />
                    </div>
                    <div>
                      <h4 className="font-bold">Summer Collection Launch</h4>
                      <p className="text-sm text-muted-foreground">Status: <span className="text-green-500 font-medium">Active</span> • 2 Influencers</p>
                    </div>
                  </div>
                  <Button variant="outline" size="sm">View Details</Button>
                </div>
              ))}
            </CardContent>
          </Card>

          {/* Recommended Influencers (If Brand) */}
          {user.role === "brand" && (
            <div>
              <div className="flex items-center justify-between mb-4">
                <h3 className="text-xl font-display font-bold">AI Recommended for You</h3>
                <Button variant="link">View All</Button>
              </div>
              <div className="grid md:grid-cols-2 gap-4">
                {influencers.slice(0, 2).map(inf => (
                  <InfluencerCard key={inf.id} influencer={inf} />
                ))}
              </div>
            </div>
          )}
        </div>

        {/* Sidebar / Widgets */}
        <div className="space-y-8">
           <Card>
             <CardHeader>
               <CardTitle>Recent Activity</CardTitle>
             </CardHeader>
             <CardContent>
               <div className="space-y-4">
                 <ActivityItem 
                   text="Campaign 'Tech Review' approved" 
                   time="2 hours ago" 
                   icon={<CheckCircle2 className="size-4 text-green-500" />} 
                 />
                 <ActivityItem 
                   text="New proposal from @chloestyles" 
                   time="5 hours ago" 
                   icon={<Users className="size-4 text-blue-500" />} 
                 />
                 <ActivityItem 
                   text="Payment of $1,500 released" 
                   time="1 day ago" 
                   icon={<DollarSign className="size-4 text-yellow-500" />} 
                 />
               </div>
             </CardContent>
           </Card>
           
           <Card className="bg-primary text-primary-foreground">
             <CardHeader>
               <CardTitle>Need Help?</CardTitle>
               <CardDescription className="text-primary-foreground/80">Our support team is here 24/7.</CardDescription>
             </CardHeader>
             <CardContent>
               <Button variant="secondary" className="w-full">Contact Support</Button>
             </CardContent>
           </Card>
        </div>
      </div>
    </DashboardLayout>
  );
}

function StatsCard({ title, value, icon, trend }: any) {
  return (
    <Card>
      <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
        <CardTitle className="text-sm font-medium">
          {title}
        </CardTitle>
        <div className="text-muted-foreground">
          {icon}
        </div>
      </CardHeader>
      <CardContent>
        <div className="text-2xl font-bold">{value}</div>
        <p className="text-xs text-muted-foreground mt-1">
          {trend}
        </p>
      </CardContent>
    </Card>
  );
}

function ActivityItem({ text, time, icon }: any) {
  return (
    <div className="flex items-start gap-3">
      <div className="mt-1 shrink-0">{icon}</div>
      <div>
        <p className="text-sm font-medium leading-none">{text}</p>
        <p className="text-xs text-muted-foreground mt-1">{time}</p>
      </div>
    </div>
  );
}

function MegaphoneIcon(props: any) {
  return <MegaphoneIconComp {...props} />;
}
const MegaphoneIconComp = (props: any) => (
  <svg
    {...props}
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    strokeLinecap="round"
    strokeLinejoin="round"
  >
    <path d="m3 11 18-5v12L3 14v-3z" />
    <path d="M11.6 16.8a3 3 0 1 1-5.8-1.6" />
  </svg>
);
