import { DashboardLayout } from "@/components/layout/DashboardLayout";
import { useLanguage } from "@/context/LanguageContext";
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { AlertTriangle, MessageSquare, Paperclip, CheckCircle } from "lucide-react";

export default function DisputesPage() {
  const { t } = useLanguage();

  const disputes = [
    {
      id: "DIS-2024-001",
      campaign: "Summer Launch 2025",
      influencer: "Chloe Styles",
      reason: "Late Delivery",
      amount: "$1,500.00",
      status: "Open",
      date: "2024-05-21"
    }
  ];

  return (
    <DashboardLayout>
      <div className="mb-8">
        <h1 className="text-3xl font-display font-bold">Resolution Center</h1>
        <p className="text-muted-foreground">Manage disputes and request refunds securely.</p>
      </div>

      <Tabs defaultValue="active" className="space-y-6">
        <TabsList>
          <TabsTrigger value="active">Active Disputes</TabsTrigger>
          <TabsTrigger value="closed">Resolved</TabsTrigger>
        </TabsList>

        <TabsContent value="active">
          <div className="grid gap-6">
            {disputes.map((dispute) => (
              <Card key={dispute.id}>
                <CardHeader className="flex flex-row items-center justify-between pb-2">
                  <div>
                    <CardTitle className="text-lg flex items-center gap-2">
                      {dispute.id}
                      <Badge variant="destructive" className="ml-2">Action Required</Badge>
                    </CardTitle>
                    <CardDescription>
                      Campaign: <span className="font-medium text-foreground">{dispute.campaign}</span>
                    </CardDescription>
                  </div>
                  <div className="text-right">
                    <span className="font-bold text-xl">{dispute.amount}</span>
                    <p className="text-xs text-muted-foreground">Escrow Held</p>
                  </div>
                </CardHeader>
                <CardContent>
                  <div className="bg-secondary/20 p-4 rounded-lg border border-border/50 mb-6">
                    <div className="grid md:grid-cols-2 gap-4 text-sm">
                       <div>
                         <span className="text-muted-foreground">Reason:</span>
                         <p className="font-medium">{dispute.reason}</p>
                       </div>
                       <div>
                         <span className="text-muted-foreground">Party Involved:</span>
                         <p className="font-medium">{dispute.influencer}</p>
                       </div>
                    </div>
                  </div>

                  <div className="flex flex-col sm:flex-row gap-3">
                    <Button className="flex-1 bg-primary">
                      <MessageSquare className="mr-2 size-4" /> View Evidence & Chat
                    </Button>
                    <Button variant="outline" className="flex-1">
                      <Paperclip className="mr-2 size-4" /> Submit New Evidence
                    </Button>
                    <Button variant="secondary" className="flex-1 text-red-600 hover:bg-red-50">
                      Escalate to Admin
                    </Button>
                  </div>
                </CardContent>
              </Card>
            ))}
            
            {disputes.length === 0 && (
               <div className="text-center py-12 border border-dashed rounded-xl">
                 <CheckCircle className="size-12 text-green-500 mx-auto mb-4" />
                 <h3 className="text-lg font-bold">No Active Disputes</h3>
                 <p className="text-muted-foreground">All your campaigns are running smoothly.</p>
               </div>
            )}
          </div>
        </TabsContent>
        
        <TabsContent value="closed">
           <div className="text-center py-12 border border-dashed rounded-xl text-muted-foreground">
             No resolved disputes yet.
           </div>
        </TabsContent>
      </Tabs>
    </DashboardLayout>
  );
}
