import { Navbar } from "@/components/layout/Navbar";
import { Footer } from "@/components/layout/Footer";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Accordion, AccordionContent, AccordionItem, AccordionTrigger } from "@/components/ui/accordion";
import { Input } from "@/components/ui/input";
import { Button } from "@/components/ui/button";
import { Search, Book, Shield, HelpCircle, FileText } from "lucide-react";

export default function HelpCenterPage() {
  return (
    <div className="min-h-screen bg-background flex flex-col">
      <Navbar />
      
      {/* Hero Search */}
      <div className="bg-primary py-20 px-4 text-center text-primary-foreground">
        <h1 className="text-3xl md:text-5xl font-display font-bold mb-6">How can we help you?</h1>
        <div className="max-w-2xl mx-auto relative">
          <Search className="absolute left-4 top-3.5 size-5 text-muted-foreground" />
          <Input 
            className="h-12 pl-12 bg-white text-foreground placeholder:text-muted-foreground rounded-full shadow-xl border-0" 
            placeholder="Search for answers (e.g., 'payment methods', 'verification')..."
          />
        </div>
      </div>

      <div className="container mx-auto px-4 py-12 flex-1">
        <div className="grid md:grid-cols-3 gap-8 mb-16">
          <HelpCard icon={<Book className="size-8 text-blue-500" />} title="Getting Started" desc="Guides for Brands and Influencers setting up their accounts." />
          <HelpCard icon={<Shield className="size-8 text-green-500" />} title="Safety & Trust" desc="Learn about our KYC process and Escrow protection." />
          <HelpCard icon={<FileText className="size-8 text-purple-500" />} title="Billing & Fees" desc="Understanding platform fees, deposits and withdrawals." />
        </div>

        <div className="max-w-3xl mx-auto">
          <h2 className="text-2xl font-bold mb-6">Frequently Asked Questions</h2>
          <Accordion type="single" collapsible className="w-full">
            <AccordionItem value="item-1">
              <AccordionTrigger>How does the Escrow system work?</AccordionTrigger>
              <AccordionContent>
                When a brand starts a campaign, the budget is deposited into a secure Escrow account. The funds are held safely until the influencer delivers the agreed-upon content. Once the brand approves the work, the funds are automatically released to the influencer's wallet. This protects both parties.
              </AccordionContent>
            </AccordionItem>
            <AccordionItem value="item-2">
              <AccordionTrigger>What are the platform fees?</AccordionTrigger>
              <AccordionContent>
                InfluencerHub AI charges a flat 15% service fee on all completed transactions. This covers payment processing, escrow security, and platform maintenance. There are no monthly subscription fees for basic accounts.
              </AccordionContent>
            </AccordionItem>
            <AccordionItem value="item-3">
              <AccordionTrigger>How do I get verified?</AccordionTrigger>
              <AccordionContent>
                To get the "Verified" badge, influencers must connect their social accounts via OAuth. Our system automatically analyzes your audience authenticity, engagement rates, and growth history. We also require a valid government ID for KYC (Know Your Customer) compliance.
              </AccordionContent>
            </AccordionItem>
            <AccordionItem value="item-4">
              <AccordionTrigger>Can I pay with Crypto?</AccordionTrigger>
              <AccordionContent>
                Yes! We support deposits via USDT (Tether) on the TRC20 and ERC20 networks. Crypto deposits are credited after 3 network confirmations.
              </AccordionContent>
            </AccordionItem>
          </Accordion>
        </div>
      </div>

      <Footer />
    </div>
  );
}

function HelpCard({ icon, title, desc }: any) {
  return (
    <Card className="hover:shadow-lg transition-all cursor-pointer group">
      <CardContent className="p-8 text-center">
        <div className="mb-4 flex justify-center group-hover:scale-110 transition-transform">{icon}</div>
        <h3 className="font-bold text-lg mb-2">{title}</h3>
        <p className="text-muted-foreground">{desc}</p>
      </CardContent>
    </Card>
  );
}
