import { DashboardLayout } from "@/components/layout/DashboardLayout";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { Input } from "@/components/ui/input";
import { Button } from "@/components/ui/button";
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar";
import { ScrollArea } from "@/components/ui/scroll-area";
import { Send, MoreVertical, Phone, Video } from "lucide-react";
import { useState } from "react";

export default function MessagesPage() {
  const [message, setMessage] = useState("");
  
  const contacts = [
    { id: 1, name: "Chloe Styles", lastMsg: "Sounds good! When do we start?", time: "2m", active: true, avatar: "https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=150" },
    { id: 2, name: "TechNova Inc.", lastMsg: "I've sent the contract.", time: "1h", active: false, avatar: "https://images.unsplash.com/photo-1560250097-0b93528c311a?w=150" },
    { id: 3, name: "Support Team", lastMsg: "Ticket #492 resolved.", time: "1d", active: false, avatar: "" },
  ];

  const messages = [
    { id: 1, sender: "Chloe Styles", content: "Hi! I reviewed the brief for the Summer Campaign.", time: "10:30 AM", isMe: false },
    { id: 2, sender: "Me", content: "Great! Do you have any questions about the deliverables?", time: "10:32 AM", isMe: true },
    { id: 3, sender: "Chloe Styles", content: "No, it looks clear. I can start filming this weekend.", time: "10:33 AM", isMe: false },
    { id: 4, sender: "Me", content: "Perfect. I've initiated the escrow deposit.", time: "10:35 AM", isMe: true },
    { id: 5, sender: "Chloe Styles", content: "Sounds good! When do we start?", time: "10:36 AM", isMe: false },
  ];

  return (
    <DashboardLayout>
      <div className="h-[calc(100vh-8rem)] grid md:grid-cols-3 gap-6">
        
        {/* Contacts List */}
        <Card className="col-span-1 hidden md:flex flex-col">
          <CardHeader className="p-4 border-b">
            <CardTitle className="text-lg">Messages</CardTitle>
            <Input placeholder="Search conversations..." className="mt-2" />
          </CardHeader>
          <ScrollArea className="flex-1">
            <div className="flex flex-col gap-1 p-2">
              {contacts.map((contact) => (
                <div key={contact.id} className={`flex items-center gap-3 p-3 rounded-lg cursor-pointer hover:bg-secondary/50 transition-colors ${contact.id === 1 ? 'bg-secondary' : ''}`}>
                  <div className="relative">
                    <Avatar>
                      <AvatarImage src={contact.avatar} />
                      <AvatarFallback>{contact.name.charAt(0)}</AvatarFallback>
                    </Avatar>
                    {contact.active && <div className="absolute bottom-0 right-0 size-3 bg-green-500 rounded-full border-2 border-background" />}
                  </div>
                  <div className="flex-1 overflow-hidden">
                    <div className="flex justify-between items-center mb-1">
                      <span className="font-bold text-sm truncate">{contact.name}</span>
                      <span className="text-xs text-muted-foreground">{contact.time}</span>
                    </div>
                    <p className="text-xs text-muted-foreground truncate">{contact.lastMsg}</p>
                  </div>
                </div>
              ))}
            </div>
          </ScrollArea>
        </Card>

        {/* Chat Window */}
        <Card className="md:col-span-2 flex flex-col">
          {/* Chat Header */}
          <div className="p-4 border-b flex items-center justify-between bg-card rounded-t-xl">
            <div className="flex items-center gap-3">
              <Avatar>
                <AvatarImage src={contacts[0].avatar} />
                <AvatarFallback>CS</AvatarFallback>
              </Avatar>
              <div>
                <h3 className="font-bold">Chloe Styles</h3>
                <p className="text-xs text-green-500 flex items-center gap-1">
                  <span className="size-1.5 bg-green-500 rounded-full" /> Online
                </p>
              </div>
            </div>
            <div className="flex gap-2">
               <Button variant="ghost" size="icon"><Phone className="size-4" /></Button>
               <Button variant="ghost" size="icon"><Video className="size-4" /></Button>
               <Button variant="ghost" size="icon"><MoreVertical className="size-4" /></Button>
            </div>
          </div>

          {/* Messages Area */}
          <ScrollArea className="flex-1 p-4 bg-secondary/10">
            <div className="space-y-4">
              {messages.map((msg) => (
                <div key={msg.id} className={`flex ${msg.isMe ? 'justify-end' : 'justify-start'}`}>
                  <div className={`max-w-[70%] rounded-2xl px-4 py-2 ${msg.isMe ? 'bg-primary text-primary-foreground rounded-br-none' : 'bg-white dark:bg-gray-800 border border-border/50 rounded-bl-none'}`}>
                    <p className="text-sm">{msg.content}</p>
                    <p className={`text-[10px] mt-1 text-right ${msg.isMe ? 'text-primary-foreground/70' : 'text-muted-foreground'}`}>{msg.time}</p>
                  </div>
                </div>
              ))}
            </div>
          </ScrollArea>

          {/* Input Area */}
          <div className="p-4 border-t bg-card rounded-b-xl">
            <div className="flex gap-2">
              <Input 
                placeholder="Type a message..." 
                value={message} 
                onChange={(e) => setMessage(e.target.value)}
                className="flex-1"
              />
              <Button size="icon" className="rounded-full">
                <Send className="size-4" />
              </Button>
            </div>
          </div>
        </Card>

      </div>
    </DashboardLayout>
  );
}
